IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HospitalPatientByMrnGet]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HospitalPatientByMrnGet] 	
END
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date:   17 September 2015
-- Description:   Gets a specified record from the HospitalPatient table by MRN.
-- =============================================
CREATE PROCEDURE [hips].[HospitalPatientByMrnGet] 
(
	@Mrn VARCHAR(20) = NULL
)
AS
BEGIN

	SELECT
		PatientId,
		PatientMasterId,
		HospitalId,
		Mrn,
		DateCreated,
		UserCreated,
		DateModified,
		UserModified
	FROM hips.HospitalPatient
	WHERE (@Mrn = Mrn OR @Mrn is NULL)
	ORDER BY DateModified DESC
	
END
GO
